IF EXISTS (SELECT * FROM sys.objects
		  WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_COMPRADOR_GRUPO_APLICAR]')
			 AND type IN ( N'P', N'PC') )
    DROP PROCEDURE [dbo].[P_EST_COMPRADOR_GRUPO_APLICAR];
GO

GO
--EXEC P_EST_COMPRADOR_GRUPO_APLICAR
CREATE PROCEDURE P_EST_COMPRADOR_GRUPO_APLICAR @CD_CTR_APLICAR INT
WITH ENCRYPTION
AS 
DECLARE @CD_EMP INT
DECLARE @CD_COMPRADOR INT
DECLARE @CD_PROD INT
DECLARE @CD_CTR_COMPRADOR_CTR INT
DECLARE @CD_CTR INT
SET NOCOUNT ON;
	   DECLARE CCompradorCadastro CURSOR FAST_FORWARD FOR
		SELECT
			CD_EMP,
			CD_PROD,
			CD_COMPRADOR
		FROM
			EST_COMPRADOR_GRUPO_APLICAR_CPL
		WHERE 
			CD_CTR = @CD_CTR_APLICAR

	   OPEN CCompradorCadastro;
	   FETCH NEXT FROM CCompradorCadastro INTO @CD_EMP,@CD_PROD,@CD_COMPRADOR;

	   WHILE @@FETCH_STATUS = 0
		  BEGIN
				SET @CD_CTR = ISNULL((SELECT TOP 1   -- FOI ADICIONADO TOP 1 PARA EVITAR ERRO QUANDO SE TEM MAIS DE UM COMPRADOR COM O MESMO CÓDIGO
										CD_CTR
									FROM
										EST_PROD_COMPRADOR
									WHERE
										CD_COMPRADOR = @CD_COMPRADOR),0)
				IF @CD_CTR=0 
					BEGIN
						INSERT INTO EST_PROD_COMPRADOR
						(CD_EMP,
						CD_COMPRADOR,
						DT_CAD,
						CD_USU,
						DT_ULT_ALT)
						SELECT
							@CD_EMP,
							@CD_COMPRADOR,
							GETDATE(),
							1,
							NULL
						
						SET @CD_CTR = (SELECT IDENT_CURRENT('EST_PROD_COMPRADOR'))
					END

			 DELETE FROM EST_PROD_COMPRADOR_CPL WHERE CD_EMP=@CD_EMP AND CD_PROD=@CD_PROD	

			INSERT INTO EST_PROD_COMPRADOR_CPL
			(CD_CTR,
			CD_EMP,
			CD_PROD,
			DT_CAD)
			SELECT       
				@CD_CTR,
				@CD_EMP, 
				@CD_PROD,
				GETDATE()

			 FETCH NEXT FROM CCompradorCadastro INTO @CD_EMP,@CD_PROD,@CD_COMPRADOR;
		  END ;

	   CLOSE CCompradorCadastro ;
	   DEALLOCATE CCompradorCadastro ;